/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import java.util.Arrays;
import java.util.List;
import lotr.common.fac.LOTRFaction;
import lotr.common.world.map.LOTRConquestGrid;
import lotr.common.world.map.LOTRConquestZone;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.world.World;

public class CommandConquestClear
extends CommandBase {
    public String func_71517_b() {
        return "conqclear";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/conqclear <faction> <radial> [x] [z]";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int i) {
        return false;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            List<String> factions = LOTRFaction.getPlayableAlignmentFactionNames();
            return CommandConquestClear.func_71530_a((String[])args, (String[])factions.toArray(new String[0]));
        }
        if (args.length == 2) {
            return Arrays.asList("radial");
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String langkey;
        int z;
        int x;
        LOTRFaction faction;
        World world = sender.func_130014_f_();
        if (!LOTRConquestGrid.conquestEnabled(world)) {
            throw new WrongUsageException("commands.lotr.conquest.notEnabled", new Object[0]);
        }
        if (args.length >= 1) {
            faction = LOTRFaction.forName(args[0]);
            if (faction == null) {
                throw new WrongUsageException("commands.lotr.conquest.noFaction", new Object[]{args[0]});
            }
            boolean radial = args.length >= 2 && args[1].equals("radial");
            int index = radial ? 2 : 1;
            x = sender.func_82114_b().field_71574_a;
            z = sender.func_82114_b().field_71573_c;
            if (args.length >= index + 2) {
                x = CommandConquestClear.func_71526_a((ICommandSender)sender, (String)args[index]);
                z = CommandConquestClear.func_71526_a((ICommandSender)sender, (String)args[index + 1]);
            }
            LOTRConquestZone conqZone = LOTRConquestGrid.getZoneByWorldCoords(x, z);
            if (conqZone.isDummyZone) {
                throw new WrongUsageException("commands.lotr.conquest.outOfBounds", new Object[]{x, z});
            }
            langkey = "commands.lotr.conqclear";
            if (radial) {
                float value = conqZone.getConquestStrength(faction, world);
                LOTRConquestGrid.doRadialConquest(world, conqZone, null, null, faction, value, value);
                langkey = langkey + ".radial";
            } else {
                conqZone.setConquestStrength(faction, 0.0f, world);
            }
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        CommandConquestClear.func_152373_a((ICommandSender)sender, (ICommand)this, (String)langkey, (Object[])new Object[]{faction.factionName(), x, z});
    }
}

